import settings from 'electron-settings';
import englishIcon from 'resources/images/flag_england.svg';
import frenchIcon from 'resources/images/flag_france.svg';
import germanIcon from 'resources/images/flag_germany.svg';
import spanishIcon from 'resources/images/flag_spain.svg';
import italicIcon from 'resources/images/flag_italy.svg';
import russianIcon from 'resources/images/flag_russia.svg';
import japaneseIcon from 'resources/images/flag_japan.png';
import chineseIcon from 'resources/images/flag_china.png';
import usaIcon from 'resources/images/countries/united-states-of-america.svg';
import portugalIcon from 'resources/images/countries/portugal.svg';
import israelIcon from 'resources/images/countries/israel.svg';
import koreaIcon from 'resources/images/countries/korea,-republic-of.svg';
import stringsEn from './localization/en';
import stringsDe from './localization/de';
import stringsFr from './localization/fr';
import stringsIt from './localization/it';
import stringsEs from './localization/es';
import stringsRu from './localization/ru';
import stringsJp from './localization/jp';
import stringsCh from './localization/ch';
import { MODELS } from '../../library/headset/consts';

export const ALL_LANGUAGES = {
    en: { values: stringsEn, title: 'English', icon: englishIcon },
    fr: { values: stringsFr, title: 'French', icon: frenchIcon },
    de: { values: stringsDe, title: 'German', icon: germanIcon },
    es: { values: stringsEs, title: 'Spanish', icon: spanishIcon },
    it: { values: stringsIt, title: 'Italian', icon: italicIcon },
    ru: { values: stringsRu, title: 'Russian', icon: russianIcon },
    jp: { values: stringsJp, title: 'Japanese', icon: japaneseIcon },
    ch: { values: stringsCh, title: 'Chinese', icon: chineseIcon }
};

export const QCC_FW_LANGUAGES = {
    en_us: {
        title: 'English (US)',
        icon: usaIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FRC2X,
            MODELS.FREECOM2X_HARLEY,
            MODELS.FREECOM4X_HARLEY,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HONDA,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_CUSTOM,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PACKTALK_NEO_SE,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.GIVI_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.M509_UCS_SPIRIT,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    en_uk: {
        title: 'English (UK)',
        icon: englishIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FREECOM4X_HARLEY,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HONDA,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PT_CUSTOM,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PACKTALK_NEO_SE,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    sp: {
        title: 'Spanish',
        icon: spanishIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FREECOM4X_HARLEY,
            MODELS.FRC2X,
            MODELS.FREECOM2X_HARLEY,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HONDA,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PT_CUSTOM,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.GIVI_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.M509_UCS_SPIRIT,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    fr: {
        title: 'French',
        icon: frenchIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FREECOM4X_HARLEY,
            MODELS.FRC2X,
            MODELS.FREECOM2X_HARLEY,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HONDA,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PT_CUSTOM,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.GIVI_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.M509_UCS_SPIRIT,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    de: {
        title: 'German',
        icon: germanIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FREECOM4X_HARLEY,
            MODELS.FRC2X,
            MODELS.FREECOM2X_HARLEY,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HONDA,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PT_CUSTOM,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.GIVI_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.M509_UCS_SPIRIT,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    it: {
        title: 'Italian',
        icon: italicIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FREECOM4X_HARLEY,
            MODELS.FRC2X,
            MODELS.FREECOM2X_HARLEY,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HONDA,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PT_CUSTOM,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.GIVI_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.M509_UCS_SPIRIT,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    pt: {
        title: 'Portuguese',
        icon: portugalIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FREECOM4X_HARLEY,
            MODELS.FRC2X,
            MODELS.FREECOM2X_HARLEY,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HONDA,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.GIVI_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.M509_UCS_SPIRIT,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    ru: {
        title: 'Russian',
        icon: russianIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FREECOM4X_HARLEY,
            MODELS.FRC2X,
            MODELS.FREECOM2X_HARLEY,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HONDA,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_CUSTOM,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.GIVI_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.M509_UCS_SPIRIT,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    ja: {
        title: 'Japanese',
        icon: japaneseIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FREECOM4X_HARLEY,
            MODELS.FRC2X,
            MODELS.FREECOM2X_HARLEY,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_CUSTOM,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.GIVI_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.M509_UCS_SPIRIT,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    ch: {
        title: 'Chinese',
        icon: chineseIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FREECOM4X_HARLEY,
            MODELS.FRC2X,
            MODELS.FREECOM2X_HARLEY,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_CUSTOM,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PACKTALK_NEO_SE,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.GIVI_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.M509_UCS_SPIRIT,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    he: {
        title: 'Hebrew',
        icon: israelIcon,
        models: [
            MODELS.FRC4X,
            MODELS.FREECOM4X_HARLEY,
            MODELS.FRC2X,
            MODELS.FREECOM2X_HARLEY,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PACKTALK_EDGE_HONDA,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PT_CUSTOM,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_ORV,
            MODELS.PACKTALK_DELTA_V,
            MODELS.UCS_LS2,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.GIVI_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.M509_UCS_SPIRIT,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    },
    ko: {
        title: 'Korean',
        icon: koreaIcon,
        models: [
            MODELS.PACKTALK_EDGE,
            MODELS.PACKTALK_EDGE_NO_FPGA,
            MODELS.PACKTALK_PRO,
            MODELS.FC_MOTO_UCS,
            MODELS.SHOCKWAVE_MESH,
            MODELS.FREECOM4X_HARLEY,
            MODELS.PACKTALK_EDGE_HARLEY,
            MODELS.PACKTALK_NEO,
            MODELS.PACKTALK_NEO_NO_FPGA,
            MODELS.PACKTALK_NEO_LOUIS,
            MODELS.FREECOM2X_HARLEY,
            MODELS.UCS_LS2,
            MODELS.PACKTALK_OUTDOOR_FREEJUMP,
            MODELS.PACKTALK_EDGE_DUCATI,
            MODELS.PACKTALK_EDGE_HONDA,
            MODELS.PACKTALK_EDGE_KTM,
            MODELS.PT_EDGE_SIMPSON,
            MODELS.PACKTALK_ORV,
            MODELS.FRC2X,
            MODELS.FRC4X,
            MODELS.SPIRIT,
            MODELS.SPIRIT_HD,
            MODELS.M509_UCS_SPIRIT,
            MODELS.GIVI_UCS,
            MODELS.PT_OUTDOOR_CONSUMER,
            MODELS.PT_OUTDOOR_INSTRUCTOR,
            MODELS.PT_OUTDOOR_STUDENT,
            MODELS.SCHUBERTH_SC_EDGE
        ]
    }
};

export const DEFAULT_LANGUAGE_CODE = 'en';

export const currentLanguageCode = settings.hasSync('language')
    ? settings.getSync('language')
    : DEFAULT_LANGUAGE_CODE;
